/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class NBTHelper {
    private NBTHelper() {
    }

    public static NBTTagCompound getTagCompound(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public static boolean keyExists(ItemStack itemStack, String string) {
        if (itemStack == null) {
            return false;
        }
        return NBTHelper.getTagCompound(itemStack).func_74764_b(string);
    }

    public static int getInt(ItemStack itemStack, String string, int n) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return n;
        }
        return NBTHelper.getTagCompound(itemStack).func_74762_e(string);
    }

    public static void setInt(ItemStack itemStack, String string, int n) {
        NBTHelper.getTagCompound(itemStack).func_74768_a(string, n);
    }

    public static long getLong(ItemStack itemStack, String string, long l) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return l;
        }
        return NBTHelper.getTagCompound(itemStack).func_74763_f(string);
    }

    public static void setLong(ItemStack itemStack, String string, Long l) {
        NBTHelper.getTagCompound(itemStack).func_74772_a(string, l.longValue());
    }

    public static boolean getBoolean(ItemStack itemStack, String string, boolean bl) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return bl;
        }
        return NBTHelper.getTagCompound(itemStack).func_74767_n(string);
    }

    public static void setBoolean(ItemStack itemStack, String string, boolean bl) {
        NBTHelper.getTagCompound(itemStack).func_74757_a(string, bl);
    }

    public static byte getByte(ItemStack itemStack, String string, byte by) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return by;
        }
        return NBTHelper.getTagCompound(itemStack).func_74771_c(string);
    }

    public static void setByte(ItemStack itemStack, String string, byte by) {
        NBTHelper.getTagCompound(itemStack).func_74774_a(string, by);
    }

    public static byte[] getByteArray(ItemStack itemStack, String string, byte[] byArray) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return byArray;
        }
        return NBTHelper.getTagCompound(itemStack).func_74770_j(string);
    }

    public static void setByteArray(ItemStack itemStack, String string, byte[] byArray) {
        NBTHelper.getTagCompound(itemStack).func_74773_a(string, byArray);
    }

    public static double getDouble(ItemStack itemStack, String string, double d) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return d;
        }
        return NBTHelper.getTagCompound(itemStack).func_74769_h(string);
    }

    public static void setDouble(ItemStack itemStack, String string, double d) {
        NBTHelper.getTagCompound(itemStack).func_74780_a(string, d);
    }

    public static float getFloat(ItemStack itemStack, String string, float f) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return f;
        }
        return NBTHelper.getTagCompound(itemStack).func_74760_g(string);
    }

    public static void setFloat(ItemStack itemStack, String string, float f) {
        NBTHelper.getTagCompound(itemStack).func_74776_a(string, f);
    }

    public static int[] getIntArray(ItemStack itemStack, String string, int[] nArray) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return nArray;
        }
        return NBTHelper.getTagCompound(itemStack).func_74759_k(string);
    }

    public static void setIntArray(ItemStack itemStack, String string, int[] nArray) {
        NBTHelper.getTagCompound(itemStack).func_74783_a(string, nArray);
    }

    public static short getShort(ItemStack itemStack, String string, short s) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return s;
        }
        return NBTHelper.getTagCompound(itemStack).func_74765_d(string);
    }

    public static void setShort(ItemStack itemStack, String string, short s) {
        NBTHelper.getTagCompound(itemStack).func_74777_a(string, s);
    }

    public static String getString(ItemStack itemStack, String string, String string2) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return string2;
        }
        return NBTHelper.getTagCompound(itemStack).func_74779_i(string);
    }

    public static void setString(ItemStack itemStack, String string, String string2) {
        NBTHelper.getTagCompound(itemStack).func_74778_a(string, string2);
    }

    public static NBTBase getTag(ItemStack itemStack, String string) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return null;
        }
        return NBTHelper.getTagCompound(itemStack).func_74781_a(string);
    }

    public static void setTag(ItemStack itemStack, String string, NBTBase nBTBase) {
        NBTHelper.getTagCompound(itemStack).func_74782_a(string, nBTBase);
    }

    public static NBTTagCompound getCompoundTag(ItemStack itemStack, String string) {
        if (!NBTHelper.keyExists(itemStack, string)) {
            return null;
        }
        return NBTHelper.getTagCompound(itemStack).func_74775_l(string);
    }

    public static void removeTag(ItemStack itemStack, String string) {
        NBTHelper.getTagCompound(itemStack).func_82580_o(string);
    }
}

